﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO;
using System.IO.IsolatedStorage;

namespace IsolatedStorageII
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();

            try
            {
                IsolatedStorageFile file =
                    IsolatedStorageFile.GetUserStoreForApplication();

                file.CreateDirectory("Subdirectory1");
            }
            catch (IsolatedStorageException iso)
            {
                //error handling
            }
        }
        private void PhoneApplicationPage_Loaded(object sender, RoutedEventArgs e)
        {
            IsolatedStorageFile file =
                IsolatedStorageFile.GetUserStoreForApplication();
            if (!file.FileExists("Subdirectory1/HelloWorld.txt"))
            {
                loadBtn.IsEnabled = false;
            }
        }

        private void saveBtn_Click(object sender, RoutedEventArgs e)
        {
            using (IsolatedStorageFile file =
                IsolatedStorageFile.GetUserStoreForApplication())
            {
                using (IsolatedStorageFileStream stream =
                    file.CreateFile("Subdirectory1/HelloWorld.txt"))
                {
                    using (StreamWriter sw = new StreamWriter(stream))
                    {
                        sw.Write(textBox1.Text);
                        sw.Close();
                        textBox1.Text = "";
                        loadBtn.IsEnabled = true;
                    }
                }
            }
        }

        private void loadBtn_Click(object sender, RoutedEventArgs e)
        {

            using (IsolatedStorageFile file =
                IsolatedStorageFile.GetUserStoreForApplication())
            {
                using (IsolatedStorageFileStream stream =
                    file.OpenFile("Subdirectory1/HelloWorld.txt", FileMode.Open))
                {
                    using (StreamReader sr = new StreamReader(stream))
                    {
                        textBox1.Text = sr.ReadToEnd();
                    }
                }
            }
        }


    }
}